<?php
/**
 * Plugin Name: Custom Login Redirect
 * Plugin URI: https://onboarding.enwage.com/
 * Description: Redirect users to a custom login page and handle login errors.
 * Version: 1.0
 * Author: Danish Rangaiz
 * Author URI: https://onboarding.enwage.com/
 * License: GPL2
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

function um_redirect_to_custom_login() {
    if (!is_user_logged_in() && !is_admin() && !is_page('login')) {
        wp_redirect(home_url('/login/'));
        exit;
    }
}
add_action('template_redirect', 'um_redirect_to_custom_login');

// function um_login_redirect_to_home($redirect_to, $request, $user) {
//     if (isset($user->roles) && is_array($user->roles)) {
//         if (in_array('administrator', $user->roles)) {
//             return $redirect_to;
//         } else {
//             return home_url();
//         }
//     } else {
//         return $redirect_to;
//     }
// }
// add_filter('login_redirect', 'um_login_redirect_to_home', 10, 3);


// function um_login_redirect_to_home($redirect_to, $request, $user) {
//     if (isset($user->ID)) {
//         // Redirect specific users (38 and 39) to the custom URL
//         if (in_array($user->ID, [38, 39])) { 
            
//             return home_url('/onboarding-dashboard-peo-software/');
//         }
        
//         // Check if the user has the role of 'administrator'
//         if (in_array('administrator', $user->roles)) {
//             return $redirect_to;
//         } else {
//             return home_url();
//         }
//     } else {
//         return $redirect_to;
//     }
// }
// add_filter('login_redirect', 'um_login_redirect_to_home', 10, 3);

function um_login_redirect_to_home($redirect_to, $request, $user) {
    if (isset($user->ID)) {
        // Redirect specific users to their custom URLs
        if (in_array($user->ID, [38, 39, 51, 50, 55, 56, 54])) { 
            return home_url('/onboarding-dashboard-peo-software/');
        }
        if (in_array($user->ID, [44, 57, 60, 66, 67, 69])) { // Updated to include user ID 57
            return '/onboarding-dashboard-staffing-software/';
        }
        if (in_array($user->ID, [65])) { // Updated to include user ID 57
            return 'https://onboarding.enwage.com/';
        }
        // Check if the user has the role of 'administrator'
        if (in_array('administrator', $user->roles)) {
            return $redirect_to;
        } else {
            return home_url();
        }
    } else {
        return $redirect_to;
    }
}
add_filter('login_redirect', 'um_login_redirect_to_home', 10, 3);




function um_redirect_non_admin_users() {
    if (is_admin() && !current_user_can('administrator') && !(defined('DOING_AJAX') && DOING_AJAX)) {
        if (in_array('customer', wp_get_current_user()->roles) || in_array('subscriber', wp_get_current_user()->roles)) {
            wp_redirect(home_url());
            exit;
        }
    }
}
add_action('admin_init', 'um_redirect_non_admin_users');

function um_redirect_wp_admin_to_custom_login() {
    if (strpos($_SERVER['REQUEST_URI'], '/wp-admin') !== false && !is_user_logged_in()) {
        wp_redirect(home_url('/login/'));
        exit;
    }
}
add_action('init', 'um_redirect_wp_admin_to_custom_login');

function um_custom_logout_redirect() {
    wp_redirect(home_url('/login/'));
    exit();
}
add_action('wp_logout', 'um_custom_logout_redirect');

function um_login_failed() {
    wp_redirect(home_url('/login/?login=failed'));
    exit();
}
add_action('wp_login_failed', 'um_login_failed');

function um_handle_login_errors($redirect_to, $requested_redirect_to, $user) {
    if (isset($_GET['login']) && $_GET['login'] == 'failed') {
        return home_url('/login/?login=failed');
    }
    return $redirect_to;
}
add_filter('login_redirect', 'um_handle_login_errors', 10, 3);

function um_custom_login_error() {
    if (isset($_GET['login']) && $_GET['login'] == 'failed') {
        echo '<div class="login-error">Invalid username or password. Please try again.</div>';
    } elseif (isset($_GET['login']) && $_GET['login'] == 'empty') {
        echo '<div class="login-error">Username and password cannot be empty.</div>';
    }
}
add_action('login_head', 'um_custom_login_error');

function um_login_failed_redirect($username) {
    $referrer = $_SERVER['HTTP_REFERER'];
    if (!empty($referrer) && !strstr($referrer, 'login') && !strstr($referrer, 'wp-admin')) {
        wp_redirect(home_url('/login/?login=failed'));
        exit();
    }
}
add_action('wp_login_failed', 'um_login_failed_redirect');

function um_check_login_fields($user, $username, $password) {
    if (empty($username) || empty($password)) {
        wp_redirect(home_url('/login/?login=empty'));
        exit();
    }
    return $user;
}
add_filter('authenticate', 'um_check_login_fields', 30, 3);

function enqueue_custom_script() {
    wp_enqueue_script('jquery');
    wp_add_inline_script('jquery', '
        jQuery(document).ready(function($) {
            var urlParams = new URLSearchParams(window.location.search);
            var loginStatus = urlParams.get("login");

            if (loginStatus === "failed") {
                $("#user-264d5cb").after("<div class=\'elementor-error\' style=\'color: red; font-size:14px;\'>Invalid email. Please try again.</div>");
                $("#password-264d5cb").after("<div class=\'elementor-error\' style=\'color: red; font-size:14px;\'>Invalid password. Please try again.</div>");
            } else if (loginStatus === "empty") {
                $("#user-264d5cb").after("<div class=\'elementor-error\' style=\'color: red; font-size:14px;\'>Username cannot be empty.</div>");
                $("#password-264d5cb").after("<div class=\'elementor-error\' style=\'color: red; font-size:14px;\'>Password cannot be empty.</div>");
            }
        });
    ');
}
add_action('wp_enqueue_scripts', 'enqueue_custom_script');

